#!/bin/bash
# Copyright the DentVLM team.
#
# This shell script automates the process of training and inference using the 
# DentVLM model pipeline. It sequentially runs the training and inference steps.
#
# **Important**:
# - This script is provided for **code review purposes** only.
# - Unauthorized use for any other purpose, including commercial use, is strictly prohibited 
#   without prior written consent from the authors.


# Generate tokenized data first
FORCE_TORCHRUN=1 llamafactory-cli train train_script/qwen2vl_full_sft_stage1.yaml
FORCE_TORCHRUN=1 llamafactory-cli train train_script/qwen2vl_full_sft_stage2.yaml

# Conduct 2-stage training
FORCE_TORCHRUN=1 llamafactory-cli train train_script/qwen2vl_full_sft_stage1.yaml
FORCE_TORCHRUN=1 llamafactory-cli train train_script/qwen2vl_full_sft_stage2.yaml

# Conduct inference
CUDA_VISIBLE_DEVICES=0 python inference.py \
                        --model_dir checkpoints/DentVLM_2nd_train \
                        --test_file data/test_set.json \
                        --output_path answer/answer.json \
                        --proc_total 1 \
                        --proc_id 0

# Evaluate the results
python get_score.py \
    --input_path answer/answer.json \
    --output_path answer/answer_score.json \
    --proc_total 1
